<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\Hacienda\TipoCambioController;
use App\Http\Controllers\Api\Hacienda\DocumentoController;
use App\Http\Controllers\Api\Hacienda\WebhookHaciendaController;
use App\Http\Middleware\BasicAuthCliente;
use App\Http\Middleware\InjectBranchContext;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/v1/tc', TipoCambioController::class);

Route::controller(DocumentoController::class)->group(function () {
    Route::get('/v1/sucursales/listar', 'consultarSucursalesCliente')->middleware(BasicAuthCliente::class);
    Route::get('/v1/documentos/listar', 'consultarDocumentosCliente')->middleware(BasicAuthCliente::class);
   
    Route::post('/v1/documentos/add', 'agregarDocumento')->middleware(InjectBranchContext::class);
    Route::post('/v1/documentos/credenciales', 'agregarCredenciales')->middleware(BasicAuthCliente::class);

    Route::get('/v1/documentos/{clave}/estado', 'consultarEstadoDocumento')->middleware(InjectBranchContext::class);
    Route::get('/v1/documentos/{clave}/respuestaXml', 'descargarRespuestaXml')->where('clave', '.{50}');;
    Route::get('/v1/documentos/{clave}/firmadoXml', 'descargarFirmadoXml')->where('clave', '.{50}');

    Route::post('/v1/clientes/agregar', 'agregarCliente');
    
    Route::put('/v1/clientes/sucursal/{sucursalId}', 'actualizarSucursal')->middleware(BasicAuthCliente::class);
    Route::post('/v1/clientes/sucursal', 'agregarSucursal')->middleware(BasicAuthCliente::class);
    Route::delete('/v1/clientes/sucursal/{sucursalId}', 'eliminarSucursal')->middleware(BasicAuthCliente::class);

    Route::get('/v1/clientes/sucursal/{sucursalId}/keys', 'consultarSucursalApiKeys')->middleware(BasicAuthCliente::class);
    Route::post('/v1/clientes/sucursal/{sucursalId}/keys', 'agregarSucursalApiKey')->middleware(BasicAuthCliente::class);
});

Route::post('/v1/webhook/mh', WebhookHaciendaController::class);